<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function statuses()
    {
        return $this->belongsToMany('App\Models\Status', 'order_statuses', 'order_id', 'status_id')->withTimestamps();
    }

}